#include "stdafx.h"
#ifdef __ENABLE_NEW_OFFLINESHOP__
#include "../common/tables.h"
#include "packet.h"
#include "item.h"
#include "char.h"
#include "item_manager.h"
#include "desc.h"
#include "char_manager.h"
#include "new_offlineshop.h"
#include "new_offlineshop_manager.h"

namespace offlineshop
{
	/*
	strcture
	-	vector of items
	-	amount of valute
	-	owner character

	metodhs
	- 	constructor which set the character owner

	-	setitems to set items when created object
	-	setvalute to set the valute when created object

	-	additem to add an item in the stock
	-	removeitem to remove item in the stock

	-	addvalute to add amount to the valute counts
	-	removevalute to remove amount to the valute counts (return false if val>amount)

	-	getitem to easly find item by id
	-	getvalutes to get the amounts
	-	getitems to get a pointer to the item vectors

	-	getowner to get the character owner
	*/

	CShopSafebox::CShopSafebox(LPCHARACTER chOwner)
	{
		ZeroObject(m_valutes);
		m_pkOwner = chOwner;
	}

	CShopSafebox::CShopSafebox()
	{
		ZeroObject(m_valutes);
		m_pkOwner = nullptr;
	}

	CShopSafebox::CShopSafebox(const CShopSafebox& rCopy)
	{
		CopyObject(m_valutes , rCopy.m_valutes);
		CopyContainer(m_vecItems , rCopy.m_vecItems);
		m_pkOwner = rCopy.m_pkOwner;
	}

	CShopSafebox::~CShopSafebox()
	{
	}

	void CShopSafebox::SetOwner(LPCHARACTER ch)
	{
		m_pkOwner = ch;
	}

	void CShopSafebox::SetItems(VECITEM * pVec)
	{
		CopyContainer(m_vecItems, *pVec);
	}

	void CShopSafebox::SetValutesAmount(const SValuteAmount val)
	{
		CopyObject(m_valutes, val);
	}

	bool CShopSafebox::AddItem(CShopItem * pItem)
	{
		CShopItem* pSearch = nullptr;
		if (GetItem(pItem->GetID(), &pSearch))
			return false;

		m_vecItems.emplace_back(*pItem);
		return true;
	}

	bool CShopSafebox::RemoveItem(DWORD dwItemID)
	{
		for (auto it = m_vecItems.begin(); it != m_vecItems.end(); ++it)
		{
			if (dwItemID == it->GetID())
			{
				m_vecItems.erase(it);
				return true;
			}
		}
		return false;
	}

	void CShopSafebox::AddValutes(const SValuteAmount val)
	{
		m_valutes += val;
	}

	bool CShopSafebox::RemoveValutes(SValuteAmount val)
	{
		if(m_valutes.illYang < val.illYang)
		{
			return false;
		}

#ifdef __ENABLE_CHEQUE_SYSTEM__
		if(m_valutes.iCheque < val.iCheque)
		{
			return false;
		}
#endif
		m_valutes -= val;
		return true;
	}

	CShopSafebox::VECITEM * CShopSafebox::GetItems()
	{
		return &m_vecItems;
	}

	CShopSafebox::SValuteAmount CShopSafebox::GetValutes()
	{
		return m_valutes;
	}

	bool CShopSafebox::GetItem(DWORD dwItemID, CShopItem ** ppItem)
	{
		for (auto& vecItem : m_vecItems)
		{
			if (dwItemID == vecItem.GetID())
			{
				*ppItem = &vecItem;
				return true;
			}
		}
		return false;
	}

	LPCHARACTER CShopSafebox::GetOwner() const
	{
		return m_pkOwner;
	}

	bool CShopSafebox::RefreshToOwner(LPCHARACTER ch) const
	{
		if(!ch && !m_pkOwner)
		{
			 return false;
		}

		if(!ch)
		{
			ch=m_pkOwner;
		}

		TValutesInfo valutes;
		valutes.illYang = m_valutes.illYang;
#ifdef __ENABLE_CHEQUE_SYSTEM__
		valute.iCheque = m_valutes.iCheque;
#endif
		OFFSHOP_DEBUG("valute %lld , items count %u", valutes.illYang, m_vecItems.size());
		GetManager().SendShopSafeboxRefresh(ch , valutes, m_vecItems);
		return true;
	}
}
#endif
